capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\DNSP 2025 benchmarking\Stata files\TFP Analysis\Data management"
set more off
log using Outputs/log/crDNSPbench25-ind, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Benchmarking
Author:  Michael Cunningham
File:    crDNSPbench25-ind.do
Initial Date:    20-May-2022
Revised Date:	 22-May-2025
--------------------------------------------------------------------------*/

local varlist revenue energy customers maxdemand ratchetmd circlength cmos ///
	price_cmos opex price_opex overheadst overheadd undergrst undergrd ///
    transform auc_overheadst auc_overheadd auc_undergrst auc_undergrd  ///
	auc_transform  	

***	Read data ********

import excel using "Input/DNSP consolidated benchmarking data (2024).xlsx", ///
	sheet("Shazam Industry Data") cellrange(A1:X21) clear firstrow case(l) 
drop in 1
destring, replace	

***	Rename variables ********		
	
rename totalrevenue                   revenue
rename customernumbers                customers	
rename maximumdemand                  maxdemand
rename ratchetedmaximumdemand         ratchetmd
rename circuitlength                  circlength	
rename customerminutesoffsupply       cmos	
rename pricecustomerminutesoffsuppl   price_cmos 	
rename priceopex                      price_opex	
rename overheadsubtransmissionlines   overheadst 	
rename overheaddistributionlinesund   overheadd
rename undergroundsubtransmissionline undergrst
rename undergrounddistributionlines   undergrd
rename transformersexcludingfirststa  transform
rename aucoverheadsubtransmission     auc_overheadst
rename aucoverheaddistribution        auc_overheadd
rename aucundergroundsubtransmission  auc_undergrst
rename aucundergrounddistribution     auc_undergrd
rename auctransformersexcludingfirst  auc_transform
rename x  							  mdindex

***	Misc data management & save ********

drop u v
label variable mdindex      "Maximum demand index (2006 = 1)"		
format %14.0g `varlist'

gen dnsp = 14
sort dnsp year
xtset dnsp year

tab1 year
describe, f		
summarize `varlist' mdindex
misstable summarize `varlist' mdindex

save Outputs/dta/dnspbench25-ind, replace

*** Create Industry Shazam input data file ********

outsheet year revenue energy ratchetmd customers circlength cmos price_cmos ///
	opex price_opex overheadst overheadd undergrst undergrd transform ///
	auc_overheadst auc_overheadd auc_undergrst auc_undergrd	auc_transform ///
	maxdemand mdindex using Outputs/csv/DINDdata.csv , comma replace

log close
exit

